# Changelog DTS 480xV2 (DTS 4801v2, DTS 4802v2, DTS 4803, DTS 4806)
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)

Possible log types:
- [Update instructions] for essential requirements and information about the firmware update procedure
- [Added] for new features
- [Changed] for changes in existing functionality. Improvements should appear under the 'changed' section
- [Deprecated] for once-stable features removed in upcoming releases
- [Removed] for now removed features in this release
- [Fixed] for any bug fixes
- [Security] for security related changes or vulnerabilities

## [01241015.03.05050157] - 2024-10-15

### Update instructions

- **DTS 4803:** Do NOT update to this firmware version with USB-Stick!
- **Downgrade:** Do NOT downgrade from this firmware version

### Added

- MIBS: Add SNMP modes: make V1 and V2c de-selectable
- MIBS: Add ntp query access control
- Logging segmentation fault to dts.log
- Logging boot reason to dts.log
- Add GPS 4500 and GNSS 4500 info (TDOP, satellite system, telegram version)
- DTS 4803: Add irig signal level configuration
- DTS 4803: Add irig alarm signal level low detection
- gitlab-ci: Validate firmware images containing MOBA-NMS string required for firmware update
- gitlab-ci: Publish a firmware release with GitLab pipelines

### Changed

- DTS 4803: Correct md5 validation during firmware update via USB flash drive for rootfs firmware image file
- DTS 4803: Set factory defaults for irig to 2Vpp (voltage peak-peak) and alarm level to 1Vpp
- DTS 4803: Change irig alarm signal level low value configuration from Ueff (effective) to Upp (peak-peak)
- DTS 4803: Update M4 firmware to version 1.9.3
- Update dropbear to version 2024.85
- Update kernel to 5.4.193
- Update update u-boot to 2020.07
- Production: Add Product IDs (0041, 0081) for colibri i.MX7 SoMs without WinCE license
- Update snmp subagent to v2.3.0
- Improve handling of snmp alive notification timeout
- Update season table to version 12
- Preserve user season table (usersn.tbl) during firmware update

### Removed

- Remove irig option mounted from dts system status bits (Bit 13)
- Remove compatibility check for maximum supported hardware version

### Fixed

- export_data_offsets.sh: fixes from CppCheck
- DTS 4803: Disable irig output if irig mode is configured as 'off'
- Release all resources after shadow file read operation (may fix login issues for dts user after changing the password or a parameter in general section)
- Menu text German fixed
- Fix SNMP IPv6
- Fix startup without IP address
- Fixes from CppCheck, clean-up compiler warnings

### Security

- Disabled FTP service in factory defaults configuration
- Disabled telnet service in factory defaults configuration
- Disabled ntpq service (no ntpq queries allowed) in factory defaults configuration
- Disabled SNMPv1/v2 (allow SNMPv3 only connection) in factory defaults configuration
- Don't allow command injection in host- and domain name
- Set umask for dtsapp to 0022 (full access for owner, group and others have read-only permission)
- Explicit set permission for /etc/shadow file to 600 (read-write for root user only) after password change
- Dropbear: Enable aes128-gcm@openssh.com  (enc)
- Dropbear: Enable aes256-gcm@openssh.com  (enc)
- Dropbear: Disable chacha20-poly1305@openssh.com (enc)
- Dropbear: Disable ssh-rsa (key)
- Dropbear: Disable diffie-hellman-group14-sha1 (kex)
- Dropbear: Disable diffie-hellman-group14-sha256 (kex)
- See also "Changed" (updates Kernel, u-boot, dropbear,..)

## [00230405.02.02020156] - 2023-04-05

### Added

- Initial version with IRIG-B on DTS 4803.masterclock

## [00020419.01.02020155] - 2019-06-24

This version was never official released

### Changed

- Updated season table to V11 (Myanmar +6.5)

### Fixed

- MOBALine high-z if voltage is out of range (T1159)
- Reset Display if button pressed (T1195)
- Terminal menu bugfixes (T1290, T1300, T1258, T1305)


## [00020419.01.02020154] - 2019-06-24

### Changed

- Improve sync char search for NMEA-ZDA packet
- Increase timeout for process supervision (softdog)

### Fixed

- SNMP: Fix settings for line 2 voltage

## [00020419.01.02020153] - 2019-04-02

### Added

- Add alarm bit for polarity fault
- DCF-Impulse mode

### Changed

- Update wide-dhcpv6
- Improve default config

### Fixed

- NTP max freq adjust
- ntp drift and offset correction
- Max. line current not displayed (T1021)
- Clock line not waiting (T1047)
- Default DCF-Impulse mode (T986)
- Leap-Second handling for DCF-Impulse mode (T1075)
- System voltage options not available for dts 4801/02 (T1026)
- Fix unwanted reboot after snmp restart (T1004)
- Other fixes: T1104, T1076, T1054

## [00231018.01.02020152] - 2018-12-17

### Added

- Initial version with DTS 4806.masterclock support

### Fixed

- Fix password change for dts user

## [00171018.01.02020151] - 2018-10-17

### Fixed

- Fix for SAM 00 (old version) movements
- Fix log file rotation

## [00310518.02.02020150] - 2018-06-07

### Added

- Initial firmware for DTS 4801/02.masterclock version 2 (DTS 480xV2)
